//
//  ProfileInfo.swift
//  Orbis
//
//  Created by KALSI on 7/3/17.
//  Copyright © 2017 KALSI. All rights reserved.
//

import UIKit

class ProfileInfo: UIViewController, UIImagePickerControllerDelegate, UINavigationControllerDelegate {

    
    @IBOutlet weak var profileImage: AsyncImageView!
    @IBOutlet weak var username: UILabel!
    @IBOutlet weak var address: UILabel!
    var picker = UIImagePickerController()
    
    override func viewWillLayoutSubviews() {
        profileImage.frame = CGRect(x: profileImage.frame.origin.x, y: profileImage.frame.origin.y, width: profileImage.frame.size.height, height: profileImage.frame.size.height)
        profileImage.layer.cornerRadius = profileImage.frame.size.height / 2;
        profileImage.layer.masksToBounds = true
       }
    
    
    //MARK:-
    override func viewDidLoad() {
        super.viewDidLoad()
        picker.delegate = self
        
        
        if UserDefaults.standard.object(forKey: "prfImgUrl") as! String != "http://54.218.78.31:50/dev//img/dashboardImage.png"{
            
            profileImage.loadImage(urlString: UserDefaults.standard.object(forKey: "prfImgUrl") as! String)
    
        }

        
      username.text = ProfileInfoModel.sharedInstance.fullname
        address.text = ProfileInfoModel.sharedInstance.address
  
    }
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
    }

    //MARK:-
    @IBAction func GoBack(_ sender: Any) {
        self.navigationController?.popViewController(animated: true)
    }
    
    @IBAction func EditProfileAction(_ sender: Any) {
        
        let controller = UIAlertController(title: "Update picture", message: nil, preferredStyle: .actionSheet)
        controller.addAction(UIAlertAction(title: "Gallery", style: .default, handler: { (UIAlertAction) in
            self.picker.sourceType = .photoLibrary
            self.present(self.picker, animated: true, completion: { })
        }))
        controller.addAction(UIAlertAction(title: "Camera", style: .default, handler: { (UIAlertAction) in
            self.picker.sourceType = .camera
            self.present(self.picker, animated: true, completion: { })
        }))
        controller.addAction(UIAlertAction(title: "Cancel", style: .cancel, handler: { (UIAlertAction) in
                controller.dismiss(animated: true, completion: { })
        }))
        self.present(controller, animated: true, completion: {  })
    }
    
    @IBAction func OtherActions(_ sender: UIButton) {
        var identifier = String()
        switch sender.tag {
        case 0:
            identifier = "Settings"
            break
        case 1:
            UserDefaults.standard.set(false, forKey: "isLogged")
            Globals().SendSignalToARC(controllerObject:self , signalType: Constants.sLogout)
            Globals().killTimers()
            identifier = "Login"
            break
        default:
            break
        }
        let vc = self.storyboard?.instantiateViewController(withIdentifier: identifier)
        self.navigationController?.pushViewController(vc!, animated: true)
    }
    
    //MARK:-
    func imagePickerController(_ picker: UIImagePickerController, didFinishPickingMediaWithInfo info: [String : Any]){
//        picture.image = info[UIImagePickerControllerOriginalImage] as? UIImage
        self.picker.dismiss(animated: true, completion: {
        })
    }
    
    func imagePickerControllerDidCancel(_ picker: UIImagePickerController){
      //  self.picker.dismiss(animated: true, completion: {
            
       // })
    }
    
}
